
cd "${utils}"

forvalues y = 2004/2016 {
	global naf nafrev2
	if inrange(`y',2004,2008) {
		global naf naf
	}

	file open myfile using "${utils}\extract_brn.sas", write replace
	// Edit path to store resulting source datafile
	file write myfile `"libname bicbrn "${rawsource}\DECFISCPRO_BIC-RN_`y'";"' _n
	file write myfile `"proc export data = bicbrn.bicrn_ex_`=substr("`y'",3,2)'_complet  (keep = siren ${naf} codpost com)"' _n
	file write myfile `"outfile = '${tmp}\bicrn_`=substr("`y'",3,2)'_nafcom'"' _n
	file write myfile `"dbms = dta replace ; run; "'_n
	file close myfile

	shell "${SASPath}" "${utils}\extract_brn.sas"
	}

forvalues y = 2017/2020 {
	global naf nafrev2

	file open myfile using "${utils}\extract_brn.sas", write replace
	file write myfile `"libname bicbrn "${rawsource}\DECFISCPRO_BIC-IS_`y'";"' _n
	file write myfile `"proc export data = bicbrn.bicis_`y' (where=(regime = 'RN') keep = siren regime ${naf} cddept cdcommune)"' _n
	file write myfile `"outfile = '${tmp}\bicrn_`=substr("`y'",3,2)'_nafcom'"' _n
	file write myfile `"dbms = dta replace ; run; "'_n
	file close myfile

	shell "${SASPath}" "${utils}\extract_brn.sas"
	}
	